local TABAS_Sprites = require("TABAS_Sprites")

local TABAS_Compat = {}
TABAS_Compat.Tiles = {}
TABAS_Compat.Exclude = {}

function TABAS_Compat.Tiles.AddBathTubTiles(bathTable)
    TABAS_Sprites.Bathtub[bathTable.groupName] = {}
    for dir, bathSprites in pairs(bathTable.sprites) do
        TABAS_Sprites.Bathtub[bathTable.groupName][dir] = bathSprites
    end
end

function TABAS_Compat.Tiles.AddShowerTiles(showerTable)
    TABAS_Sprites.Shower[showerTable.groupName] = {}
    for dir, sprite in pairs(showerTable.sprites) do
        TABAS_Sprites.Shower[groupName].dir = sprite
    end
end


-- ** If you want your mod's bath and shower tiles to work with this mod. **
local cleanbath = {
    groupName = "Large Deluxe Clean",
    sprites = {
        spriteS = {faucet="tabas_fixtures_bathroom_01_25", tub="tabas_fixtures_bathroom_01_24"},
        spriteE = {faucet="tabas_fixtures_bathroom_01_26", tub="tabas_fixtures_bathroom_01_27"},
        spriteN = {faucet="tabas_fixtures_bathroom_01_52", tub="tabas_fixtures_bathroom_01_53"},
        spriteW = {faucet="tabas_fixtures_bathroom_01_55", tub="tabas_fixtures_bathroom_01_54"}
    }
}
TABAS_Compat.Tiles.AddBathTubTiles(cleanbath)

-- ** This example of a shower. **
-- local showerExamples = {
    -- groupName = "Examples",
    -- sprites = {
        -- spriteS = "fixtures_bathroom_01_25",
        -- spriteE = "fixtures_bathroom_01_26",
        -- spriteN = "fixtures_bathroom_01_52",
        -- spriteW = "fixtures_bathroom_01_55",
    -- }
-- }
-- TABAS_Compat.Tiles.AddShowerTiles(showerExamples)

-- ** Also you can add it in this format. **
TABAS_Sprites.Shower["Deluxe"] = TABAS_Sprites.Shower["Deluxe"] or {}
-- TABAS_Sprites.Shower["Deluxe"].spriteN = "tabas_fixtures_bathroom_01_32"
-- TABAS_Sprites.Shower["Deluxe"].spriteW = "tabas_fixtures_bathroom_01_33"
TABAS_Sprites.Shower["Deluxe"].spriteN = "fixtures_bathroom_01_70"
TABAS_Sprites.Shower["Deluxe"].spriteW = "fixtures_bathroom_01_71"



TABAS_Compat.Exclude.AccessoryLocations = {
    "BellyButton",
    "EarTop",
    "Ears",
    "LeftWrist",
    "Left_MiddleFinger",
    "Left_RingFinger",
    "Necklace",
    "Necklace_Long",
    "Nose",
    "RightWrist",
    "Right_MiddleFinger",
    "Right_RingFinger",
}

TABAS_Compat.Exclude.BodyLocations = {
    "MakeUp_FullFace",
    "MakeUp_Eyes",
    "MakeUp_EyesShadow",
    "MakeUp_Lips",
    "Bandage",
    "Wound",
    "ZedDmg",
}

TABAS_Compat.Exclude.BathWear = {
    "Base.TowelHat", -- From Bathtowel Overhaul - Wearable Addon
    "Base.TowelBottom",
    "Base.TowelTop"
}



function TABAS_Compat.Exclude.AddExcludeAccessoryLocations(bodyLocation)
    table.insert(TABAS_Compat.Exclude.AccessoryLocations, bodyLocation)
end

function TABAS_Compat.Exclude.AddExcludeBodyLocations(bodyLocation)
    table.insert(TABAS_Compat.Exclude.BodyLocations, bodyLocation)
end

-- Add bodyLocations to exclude from auto undress when bathing.
-- Note: If you want to exclude a bodyLocation that is not in the list above,
TABAS_Compat.Exclude.AddExcludeBodyLocations("BodyGrime")
TABAS_Compat.Exclude.AddExcludeBodyLocations("BodyShampoo")
-- --There bodyLocations added from this mod, but them patches actually not be necessary because it doesn't have a DisplayName.


return TABAS_Compat